@echo off

REM Đường dẫn cần thêm vào PATH
set "newPath=%CD%\libs"

REM Kiểm tra xem đường dẫn đã tồn tại trong PATH User Variable chưa
setlocal enabledelayedexpansion
set "exist=0"
for %%I in ("%PATH:;=" "%") do (
  if /I "%%~I"=="%newPath%" (
    set "exist=1"
    exit /b
  )
)
if %exist%==1 (
    echo Đường dẫn "%newPath%" đã tồn tại trong PATH của User Environment.
    exit /b
)

REM Lấy giá trị hiện tại của PATH User Variable
for /f "delims=" %%a in ('powershell -Command "Get-ItemProperty -Path 'HKCU:\Environment' -Name 'Path' | Select-Object -ExpandProperty 'Path'"') do (
    set "currentPath=%%a"
)

REM Tách PATH hiện tại thành các phần tử và kiểm tra sự trùng lặp
set "finalPath="
for %%I in ("%currentPath:;=" "%") do (
  if /I not "%%~I"=="%newPath%" (
    set "finalPath=!finalPath!;%%~I"
  )
)

REM Thêm đường dẫn mới vào cuối của PATH User Variable
set "finalPath=%finalPath%;%newPath%"

REM Cập nhật giá trị mới của PATH trong User Environment bằng PowerShell
powershell -Command "Set-ItemProperty -Path 'HKCU:\Environment' -Name 'Path' -Value ('%finalPath:~1%')"

REM In thông báo khi hoàn thành
echo Đã thêm "%newPath%" vào PATH của User Environment.